if not VehicleZoneDistribution then return end

local function VMZ_MilZonesStats()
	local SpawnRate = SandboxVars.VMZ.SpawnRate
	local VehicleCondition = (SandboxVars.VMZ.VehiCond*2)/100
	local DamagedPart = SandboxVars.VMZ.PartDamage
	local KeyChance = SandboxVars.VMZ.KeySpawn
	local Special = SandboxVars.VMZ.SpecCar
	
	VehicleZoneDistribution.military = VehicleZoneDistribution.military or {}
	VehicleZoneDistribution.military.vehicles = VehicleZoneDistribution.military.vehicles or {}
	
	VehicleZoneDistribution.army = VehicleZoneDistribution.army or {}
	VehicleZoneDistribution.army.vehicles = VehicleZoneDistribution.army.vehicles or {}
	
	if VehicleZoneDistribution.army.vehicles ~= nil then
		for vehicleName, vehicleData in pairs(VehicleZoneDistribution.army.vehicles) do
			if not VehicleZoneDistribution.military.vehicles[vehicleName] then
				VehicleZoneDistribution.military.vehicles[vehicleName] = vehicleData
			end
		end
	end
	
	local activeModIDs = getActivatedMods()
	for i=1,activeModIDs:size() do
		local modID = activeModIDs:get(i-1)
		local modInfo = getModInfoByID(modID)
		if modInfo and modInfo:getWorkshopID() then
			local sharedFiles = listFilesInModDirectory(modID, "media/lua/shared")
			local sharedVFiles = listFilesInModDirectory(modID, "media/lua/shared/Vehicles")
			for i=1,sharedFiles:size() do
				local file = sharedFiles:get(i-1)
				if file:lower():find("spawn") or file:lower():find("zonedef") then
					require(file)
				end
			end
			for i=1,sharedVFiles:size() do
				local file = sharedVFiles:get(i-1)
				if file:lower():find("spawn") or file:lower():find("zonedef") then
					require(file)
				end
			end
		end
	end
	
	local zones = { "parkingstall", "trailerpark", "bad", "medium", "good", "luxuryDealership", "sport", "junkyard", "trafficjams", "police", "prison", "fire", "ranger", "mccoy", "carpenter", "postal", "spiffo", "ambulance", "radio", "fossoil", "scarlet", "massgenfac", "transit", "network3", "kyheralds", "lectromax", "knoxdisti", "advertising", "airportshuttle", "airportservice", "farm", "business", "normalburnt", "specialburnt", "trades", "delivery", "professional", "middleClass", "struggling", "evacuee" }
	for vehicleName, _ in pairs(VehicleZoneDistribution.military.vehicles) do
		for _, zoneName in ipairs(zones) do
			VehicleZoneDistribution[zoneName].vehicles[vehicleName] = nil
		end
	end

	--Burnt--

	VehicleZoneDistribution.military_burnt = VehicleZoneDistribution.military_burnt or {}
	VehicleZoneDistribution.military_burnt.vehicles = VehicleZoneDistribution.military_burnt.vehicles or {}
	VehicleZoneDistribution.military_burnt.spawnRate = SpawnRate
	VehicleZoneDistribution.military_burnt.randomAngle = true
	VehicleZoneDistribution.military_burnt.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_burnt.chanceToSpawnNormal = 0

	--Containers--

	VehicleZoneDistribution.military_container = VehicleZoneDistribution.military_container or {}
	VehicleZoneDistribution.military_container.vehicles = VehicleZoneDistribution.military_container.vehicles or {}
	VehicleZoneDistribution.military_container.spawnRate = SpawnRate
	VehicleZoneDistribution.military_container.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_container.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_container.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_container.chanceToSpawnNormal = 0
	
	VehicleZoneDistribution.military_container_angled = VehicleZoneDistribution.military_container_angled or {}
	VehicleZoneDistribution.military_container_angled.vehicles = VehicleZoneDistribution.military_container_angled.vehicles or {}
	VehicleZoneDistribution.military_container_angled.spawnRate = SpawnRate
	VehicleZoneDistribution.military_container_angled.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_container_angled.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_container_angled.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_container_angled.chanceToSpawnNormal = 0
	VehicleZoneDistribution.military_container_angled.positionAngles = { -30, -22.5, -15, -7.5, 7.5, 15, 22.5, 30 }

	--Trailers (All)--

	VehicleZoneDistribution.military_trailer = VehicleZoneDistribution.military_trailer or {}
	VehicleZoneDistribution.military_trailer.vehicles = VehicleZoneDistribution.military_trailer.vehicles or {}
	VehicleZoneDistribution.military_trailer.spawnRate = SpawnRate
	VehicleZoneDistribution.military_trailer.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_trailer.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_trailer.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_trailer.chanceToSpawnNormal = 0
	
	VehicleZoneDistribution.military_trailer_angled = VehicleZoneDistribution.military_trailer_angled or {}
	VehicleZoneDistribution.military_trailer_angled.vehicles = VehicleZoneDistribution.military_trailer_angled.vehicles or {}
	VehicleZoneDistribution.military_trailer_angled.spawnRate = SpawnRate
	VehicleZoneDistribution.military_trailer_angled.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_trailer_angled.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_trailer_angled.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_trailer_angled.chanceToSpawnNormal = 0
	VehicleZoneDistribution.military_trailer_angled.positionAngles = { -30, -22.5, -15, -7.5, 7.5, 15, 22.5, 30 }
	--Trailers (Light)--

	VehicleZoneDistribution.military_trailer_light = VehicleZoneDistribution.military_trailer_light or {}
	VehicleZoneDistribution.military_trailer_light.vehicles = VehicleZoneDistribution.military_trailer_light.vehicles or {}
	VehicleZoneDistribution.military_trailer_light.spawnRate = SpawnRate
	VehicleZoneDistribution.military_trailer_light.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_trailer_light.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_trailer_light.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_trailer_light.chanceToSpawnNormal = 0
	
	VehicleZoneDistribution.military_trailer_light_angled = VehicleZoneDistribution.military_trailer_light_angled or {}
	VehicleZoneDistribution.military_trailer_light_angled.vehicles = VehicleZoneDistribution.military_trailer_light_angled.vehicles or {}
	VehicleZoneDistribution.military_trailer_light_angled.spawnRate = SpawnRate
	VehicleZoneDistribution.military_trailer_light_angled.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_trailer_light_angled.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_trailer_light_angled.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_trailer_light_angled.chanceToSpawnNormal = 0
	VehicleZoneDistribution.military_trailer_light_angled.positionAngles = { -30, -22.5, -15, -7.5, 7.5, 15, 22.5, 30 }
	
	--Trailers (Heavy)--

	VehicleZoneDistribution.military_trailer_heavy = VehicleZoneDistribution.military_trailer_heavy or {}
	VehicleZoneDistribution.military_trailer_heavy.vehicles = VehicleZoneDistribution.military_trailer_heavy.vehicles or {}
	VehicleZoneDistribution.military_trailer_heavy.spawnRate = SpawnRate
	VehicleZoneDistribution.military_trailer_heavy.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_trailer_heavy.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_trailer_heavy.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_trailer_heavy.chanceToSpawnNormal = 0
	
	VehicleZoneDistribution.military_trailer_heavy_angled = VehicleZoneDistribution.military_trailer_heavy_angled or {}
	VehicleZoneDistribution.military_trailer_heavy_angled.vehicles = VehicleZoneDistribution.military_trailer_heavy_angled.vehicles or {}
	VehicleZoneDistribution.military_trailer_heavy_angled.spawnRate = SpawnRate
	VehicleZoneDistribution.military_trailer_heavy_angled.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_trailer_heavy_angled.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_trailer_heavy_angled.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_trailer_heavy_angled.chanceToSpawnNormal = 0
	VehicleZoneDistribution.military_trailer_heavy_angled.positionAngles = { -30, -22.5, -15, -7.5, 7.5, 15, 22.5, 30 }

	--Vehicles (All)--

	VehicleZoneDistribution.military_vehicle = VehicleZoneDistribution.military_vehicle or {}
	VehicleZoneDistribution.military_vehicle.vehicles = VehicleZoneDistribution.military_vehicle.vehicles or {}
	VehicleZoneDistribution.military_vehicle.spawnRate = SpawnRate
	VehicleZoneDistribution.military_vehicle.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_vehicle.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_vehicle.chanceToSpawnKey = KeyChance
	VehicleZoneDistribution.military_vehicle.specialCar = Special
	VehicleZoneDistribution.military_vehicle.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_vehicle.chanceToSpawnNormal = 0
	
	VehicleZoneDistribution.military_vehicle_angled = VehicleZoneDistribution.military_vehicle_angled or {}
	VehicleZoneDistribution.military_vehicle_angled.vehicles = VehicleZoneDistribution.military_vehicle_angled.vehicles or {}
	VehicleZoneDistribution.military_vehicle_angled.spawnRate = SpawnRate
	VehicleZoneDistribution.military_vehicle_angled.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_vehicle_angled.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_vehicle_angled.chanceToSpawnKey = KeyChance
	VehicleZoneDistribution.military_vehicle_angled.specialCar = Special
	VehicleZoneDistribution.military_vehicle_angled.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_vehicle_angled.chanceToSpawnNormal = 0
	VehicleZoneDistribution.military_vehicle_angled.positionAngles = { -30, -22.5, -15, -7.5, 7.5, 15, 22.5, 30 }
	
	--Vehicles (Light)--

	VehicleZoneDistribution.military_vehicle_light = VehicleZoneDistribution.military_vehicle_light or {}
	VehicleZoneDistribution.military_vehicle_light.vehicles = VehicleZoneDistribution.military_vehicle_light.vehicles or {}
	VehicleZoneDistribution.military_vehicle_light.spawnRate = SpawnRate
	VehicleZoneDistribution.military_vehicle_light.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_vehicle_light.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_vehicle_light.chanceToSpawnKey = KeyChance
	VehicleZoneDistribution.military_vehicle_light.specialCar = Special
	VehicleZoneDistribution.military_vehicle_light.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_vehicle_light.chanceToSpawnNormal = 0
	
	VehicleZoneDistribution.military_vehicle_light_angled = VehicleZoneDistribution.military_vehicle_light_angled or {}
	VehicleZoneDistribution.military_vehicle_light_angled.vehicles = VehicleZoneDistribution.military_vehicle_light_angled.vehicles
	VehicleZoneDistribution.military_vehicle_light_angled.spawnRate = SpawnRate
	VehicleZoneDistribution.military_vehicle_light_angled.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_vehicle_light_angled.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_vehicle_light_angled.chanceToSpawnKey = KeyChance
	VehicleZoneDistribution.military_vehicle_light_angled.specialCar = Special
	VehicleZoneDistribution.military_vehicle_light_angled.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_vehicle_light_angled.chanceToSpawnNormal = 0
	VehicleZoneDistribution.military_vehicle_light_angled.positionAngles = { -30, -22.5, -15, -7.5, 7.5, 15, 22.5, 30 }
	
	--Vehicles (Heavy)--

	VehicleZoneDistribution.military_vehicle_heavy = VehicleZoneDistribution.military_vehicle_heavy or {}
	VehicleZoneDistribution.military_vehicle_heavy.vehicles = VehicleZoneDistribution.military_vehicle_heavy.vehicles or {}
	VehicleZoneDistribution.military_vehicle_heavy.spawnRate = SpawnRate
	VehicleZoneDistribution.military_vehicle_heavy.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_vehicle_heavy.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_vehicle_heavy.chanceToSpawnKey = KeyChance
	VehicleZoneDistribution.military_vehicle_heavy.specialCar = Special
	VehicleZoneDistribution.military_vehicle_heavy.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_vehicle_heavy.chanceToSpawnNormal = 0
	
	VehicleZoneDistribution.military_vehicle_heavy_angled = VehicleZoneDistribution.military_vehicle_heavy_angled or {}
	VehicleZoneDistribution.military_vehicle_heavy_angled.vehicles = VehicleZoneDistribution.military_vehicle_heavy_angled.vehicles or {}
	VehicleZoneDistribution.military_vehicle_heavy_angled.spawnRate = SpawnRate
	VehicleZoneDistribution.military_vehicle_heavy_angled.baseVehicleQuality = VehicleCondition
	VehicleZoneDistribution.military_vehicle_heavy_angled.chanceToPartDamage = DamagedPart
	VehicleZoneDistribution.military_vehicle_heavy_angled.chanceToSpawnKey = KeyChance
	VehicleZoneDistribution.military_vehicle_heavy_angled.specialCar = Special
	VehicleZoneDistribution.military_vehicle_heavy_angled.chanceToSpawnSpecial = 0
	VehicleZoneDistribution.military_vehicle_heavy_angled.chanceToSpawnNormal = 0
	VehicleZoneDistribution.military_vehicle_heavy_angled.positionAngles = { -30, -22.5, -15, -7.5, 7.5, 15, 22.5, 30 }
end

Events.OnLoadMapZones.Add(VMZ_MilZonesStats)